# vmagent_yp.sh

export DEBIAN_FRONTEND="noninteractive"

tee /etc/resolv.conf << EOF
search search.yandex.net
nameserver 2a02:6b8:0:3400::5005
options timeout:1 attempts:1
EOF

tee -a /etc/hosts << EOF
2a02:6b8:0:3400::1:3 common.dist.yandex.ru
EOF

# FIXME: fixup for skynet startup
#sed '95s:DAEMON:DAEMON --no-parallel:g; 107s:DAEMON:DAEMON --no-parallel:g' -i /etc/init.d/skynetd

apt-get update -y
apt-get install -y --no-install-recommends --allow-unauthenticated python socat python-pip yandex-porto gcc python-dev realpath uuid
apt-get install -y --no-install-recommends --allow-unauthenticated python-portopy
apt-get install -y --no-install-recommends --allow-unauthenticated radvd udhcpd wide-dhcpv6-server tcpdump jq

QEMU_PKG=qemu-static

if [ $QEMU_VERSION ]; then
    QEMU_PKG="qemu-static=$QEMU_VERSION"
fi

apt-get install -y --no-install-recommends --allow-unauthenticated $QEMU_PKG

tee <<EOF /usr/sbin/qemu_launcher.sh
#!/bin/bash

. /usr/sbin/qemu_network.sh
ts1="0"

while /bin/true; do
    if [ ! -e /run/vmagent.pid ] || [ ! -e /proc/\$(cat /run/vmagent.pid) ]; then
        ts2=\$(date +%s)
        if [ "\$ts2" -lt "\$((ts1 + 5))" ]; then
            echo "vmagent failing too fast" 1>&2
            break
        fi
        ts1=\$ts2
        \$VMAGENT_PATH/vmagent --mode yp \$PORT &
        echo \$! | sudo tee /run/vmagent.pid
    fi

    if [ ! -e /run/udhcpd.pid ] || [ ! -e /proc/\$(cat /run/udhcpd.pid) ]; then
        sudo udhcpd /etc/udhcpd.conf
    fi

    if [ ! -e /run/radvd.pid ] || [ ! -e /proc/\$(cat /run/radvd.pid) ]; then
        sudo radvd -C /etc/radvd.conf
    fi

    if [ ! -e /run/dhcp6s.pid ] || [ ! -e /proc/\$(cat /run/dhcp6s.pid) ]; then
        sudo dhcp6s -c /etc/wide-dhcpv6/dhcp6s.conf \$TAP_DEV
    fi

    sleep 5
done

exit 1
EOF

chmod +x /usr/sbin/qemu_launcher.sh

mkdir /qemu-persistent
chown 1049:1049 /qemu-persistent

# Reset VM

tee <<EOF /usr/sbin/qemu_reset.sh
#!/bin/bash -e
echo "quit" | nc -U ./mon.sock
EOF

chmod 0755 /usr/sbin/qemu_reset.sh

# Reboot VM

tee <<EOF /usr/sbin/qemu_reboot.sh
#!/bin/bash -e
echo "system_powerdown" | nc -U ./mon.sock
EOF

chmod 0755 /usr/sbin/qemu_reboot.sh

# Hard reset (drop state, hdd delta) VM

tee <<EOF /usr/sbin/qemu_hard_reset.sh
#!/bin/bash -e
rm /qemu-persistent/current.hash || true
rm /qemu-persistent/current.qcow2 || true

echo "quit" | nc -U ./mon.sock
EOF

chmod 0755 /usr/sbin/qemu_hard_reset.sh

# Access VM monitor

tee <<EOF /usr/sbin/qemu_mon.sh
#!/bin/bash -e

nc -U ./mon.sock
EOF

chmod 0755 /usr/sbin/qemu_mon.sh


mkdir -p /opt || true
wget --no-check-certificate -O /opt/CloudbaseInitSetup_0_9_11_x64.msi https://proxy.sandbox.yandex-team.ru/421435392
wget --no-check-certificate -O /opt/CloudbaseInitSetup_0_9_11_x86.msi https://proxy.sandbox.yandex-team.ru/421437928


tee /opt/cloudbase-init.conf <<EOF
[DEFAULT]
username=CloudAdmin
groups=Administrators
inject_user_password=false
config_drive_raw_hhd=false
config_drive_cdrom=false
config_drive_vfat=true
bsdtar_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\bin\\bsdtar.exe
mtools_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\bin\\
verbose=true
debug=true
logdir=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\log\\
logfile=cloudbase-init.log
default_log_levels=comtypes=INFO,suds=INFO,iso8601=WARN,requests=WARN
logging_serial_port_settings=
mtu_use_dhcp_config=true
ntp_use_dhcp_config=true
local_scripts_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\LocalScripts\\
metadata_services=cloudbaseinit.metadata.services.configdrive.ConfigDriveService
EOF


tee /opt/cloudbase-init-unattend.conf <<EOF
[DEFAULT]
username=CloudAdmin
groups=Administrators
inject_user_password=false
config_drive_raw_hhd=false
config_drive_cdrom=false
config_drive_vfat=true
bsdtar_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\bin\\bsdtar.exe
mtools_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\bin\\
verbose=true
debug=true
logdir=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\log\\
logfile=cloudbase-init-unattend.log
default_log_levels=comtypes=INFO,suds=INFO,iso8601=WARN,requests=WARN
logging_serial_port_settings=
mtu_use_dhcp_config=true
ntp_use_dhcp_config=true
local_scripts_path=C:\\Program Files\\Cloudbase Solutions\\Cloudbase-Init\\LocalScripts\\
metadata_services=cloudbaseinit.metadata.services.configdrive.ConfigDriveService
plugins=cloudbaseinit.plugins.common.mtu.MTUPlugin,cloudbaseinit.plugins.common.sethostname.SetHostNamePlugin,cloudbaseinit.plugins.windows.extendvolumes.ExtendVolumesPlugin
allow_reboot=false
stop_service_on_exit=false
check_latest_version=false
EOF

chmod 0600 /etc/sudoers.d/yandex-search-user-loadbase
tee -a chmod 0600 /etc/sudoers.d/yandex-search-user-loadbase <<EOF
loadbase        ALL=NOPASSWD:SETENV: /usr/sbin/skynet_launcher.sh
loadbase        ALL=NOPASSWD: /usr/bin/vim
loadbase	ALL=NOPASSWD: /bin/hostname
loadbase	ALL=NOPASSWD: ALL
EOF
chmod 0400 /etc/sudoers.d/yandex-search-user-loadbase
