PY2_LIBRARY()

OWNER(
    frolstas
)

PEERDIR(
    library/python/resource
    library/python/deprecated/ticket_parser2

    contrib/python/requests
    contrib/python/Jinja2
    contrib/python/typing
    contrib/python/protobuf
    contrib/python/requests-unixsocket

    yt/yt/python/yt_yson_bindings
    yp/python/client

    sandbox/common

    infra/nanny/sepelib/util
    infra/nanny/vendor/porto_python
    infra/qyp/proto_lib
)

PYTHON(util/print_env_var.py VMAGENT_SECRET STDOUT vmagent_secret OUT_NOAUTO vmagent_secret)
PYTHON(util/print_env_var.py SANDBOX_TOKEN STDOUT sandbox_token OUT_NOAUTO sandbox_token)

RESOURCE(
    vmagent_secret /secrets/vmagent_secret
    sandbox_token /secrets/sandbox_token
)

RESOURCE_FILES(
    cfg_templates/launcher.sh.jinja2
    cfg_templates/linux_meta-data.jinja2
    cfg_templates/linux_network-config.jinja2
    cfg_templates/linux_user-data.jinja2
    cfg_templates/win_openstack__content__network_config.jinja2
    cfg_templates/win_openstack__latest__meta_data.json.jinja2
    cfg_templates/win_openstack__latest__user-data.jinja2
)

PY_SRCS(
    __init__.py
    auth.py
    config.py
    helpers.py
    log.py
    process.py
    server.py
    qemu_launcher.py
    qemu_ctl.py
    volume_manager.py
    resource_manager.py
)

END()
