import flask
import json
import threading

from infra.qyp.vmagent_monitoring.src import vmagent_watcher

app = flask.Flask(__name__)

BPods = vmagent_watcher.VmagentWatcher(10 * 60)
# should be not less than 10 * 60 (enough time for vm could change status)


@app.route('/unistat')
def unistat():
    len_broken_pods = 0
    for cluster_info in BPods.broken_vms_for_output.values():
        len_broken_pods += len(cluster_info["list_with_broken_vms"])
    return flask.Response(json.dumps([('total_pods_ammv', BPods.cnt_pods),
                                      ('alive_pods_ammv', BPods.cnt_pods - len_broken_pods)]))


@app.route('/broken_vms')
def broken_state_pods():
    return flask.Response(json.dumps(BPods.broken_vms_for_output, sort_keys=True, indent=4),
                          content_type='application/json')


@app.route('/bad_status_vms')
def bad_state():
    return flask.Response(json.dumps(list(vmagent_watcher.helpers.vm_to_dict(x) for x in BPods.prev_bad_state_vms),
                                     sort_keys=True, indent=4),
                          content_type='application/json')


if __name__ == '__main__':
    t = threading.Thread(target=BPods.run)
    t.daemon = True
    t.start()
    app.run(host="::", port=8000)
