from yp.client import YpClient
import copy
import datetime

SECONDS_FOR_SLEEP = 10 * 60
EPOCH = datetime.datetime.fromtimestamp(0)
GOOD_UPD_TIME = (10*60) * (10**3)     # millisecond


class Vm(object):
    root_subjs = frozenset([
        'abc:service-scope:2900:8',
        'abc:service-scope:2900:16',
        'robot-vmagent-rtc'
    ])

    def __init__(self, cluster, pod_id, state, upd_time, node_id):
        self.cluster = cluster
        self.pod_id = pod_id
        self.state = state
        self.upd_time = upd_time
        self.node_id = node_id

    def __str__(self):
        return '{} {} state: {}, upd_time: {}, node_id: {}'.format(
            self.pod_id,
            self.cluster,
            self.state,
            datetime.datetime.fromtimestamp(self.upd_time / 10 ** 3).strftime('%Y-%m-%d %H:%M:%S'),
            self.node_id
        )


def get_client(url, token):
    return YpClient(
        address=url,
        transport='http',
        config={
            'enable_https': True,
            # 'user': "robot-vmagent-rtc",
            'token': token,
            'retries': {"enable": True,
                        "count": 3,
                        "backoff": {"policy": "rounded_up_to_request_timeout"}
                        },
            "request_timeout": 3000

        }
    )


def make_ts(dt):
    return int((dt - EPOCH).total_seconds() * (10 ** 3))


def loadz(x, now_time):
    if not x:
        # print 'time is NULL'
        return make_ts(now_time)
    return x


def get_real_state(list_with_states, now_time):
    if len(list_with_states) == 0:
        return "NO_STATUS", loadz(None, now_time)
    max_time = 0
    ind = 0
    for i in range(len(list_with_states)):
        state_time = int(list_with_states[i]["feedback"]["hooks"]["updateTimestamp"])
        # print datetime.datetime.fromtimestamp(state_time / 10 ** 3).strftime('%Y-%m-%d %H:%M:%S')
        if i == 0 or state_time > max_time:
            ind = i
            max_time = state_time

    return list_with_states[ind]["currentState"], loadz(max_time, now_time)


def get_pods(cluster, client, now_time):
    pods_list = client.select_objects(
        'pod',
        selectors=[
            '/meta/id',
            '/status/agent/iss',
            '/status/scheduling/node_id'
        ],
        filter='[/labels/deploy_engine] = "QYP"'
    )
    result = []

    for item in pods_list:
        state_time = ("NO_STATUS", make_ts(now_time))
        if "currentStates" in item[1]:
            state_time = get_real_state(item[1]["currentStates"], now_time)
        result.append(Vm(
            cluster=cluster,
            pod_id=item[0],
            state=state_time[0],
            upd_time=state_time[1],
            node_id=None if not item[2] else item[2]
        ))
    return result


def vm_to_dict(vm):
    ret_dict = copy.deepcopy(vm.__dict__)
    ret_dict['upd_time'] = datetime.datetime.fromtimestamp(ret_dict['upd_time'] / 10 ** 3).strftime('%Y-%m-%d %H:%M:%S')
    return ret_dict
