import datetime
import os
import time
import logging
import copy
from infra.qyp.vmagent_monitoring.src import helpers
logging.basicConfig(level=logging.DEBUG)


class VmagentWatcher(object):
    YP_CLUSTERS = {
        'SAS': 'sas.yp.yandex.net:8443',
        'MAN': 'man.yp.yandex.net:8443',
        'VLA': 'vla.yp.yandex.net:8443',
    }

    def __init__(self, time_for_sleep=helpers.SECONDS_FOR_SLEEP, yp_token=os.environ.get("YP_TOKEN")):
        self.yp_token = yp_token
        self.seconds_for_sleep = time_for_sleep
        self.cnt_pods = 0
        self.tmp_cnt_pods = 0
        self.broken_pods = {}
        for cluster in VmagentWatcher.YP_CLUSTERS.keys():
            self.broken_pods[cluster] = {"last_upd_time": "-1", "list_with_broken_vms": []}
        self.broken_vms_for_output = self.broken_pods
        self.bad_state_vms = []
        self.prev_bad_state_vms = []

    def find_vm(self, vm):
        for x in self.prev_bad_state_vms:
            if x.pod_id == vm.pod_id and x.cluster == vm.cluster:
                return x
        return None

    def check_for_alive(self, vm):
        good_state = "ACTIVE"
        if vm.state != good_state:
            self.bad_state_vms.append(vm)
        if (helpers.make_ts(self.now_time) - vm.upd_time) > helpers.GOOD_UPD_TIME:
            return False
        if vm.state == good_state:
            return True
        old_vm = self.find_vm(vm)
        if (old_vm is None) or (old_vm.state != vm.state):
            return True
        return False

    def filter_pods(self, cluster, client):
        pods = helpers.get_pods(cluster, client, self.now_time)
        self.tmp_cnt_pods += len(pods)
        # return pods
        return_list = []
        for vm in pods:
            if not self.check_for_alive(vm):
                return_list.append(vm)
        return return_list

    def list_vms(self):
        result = {}
        for cluster, cluster_addr in VmagentWatcher.YP_CLUSTERS.iteritems():
            try:
                client = helpers.get_client(cluster_addr, self.yp_token)
                pods = self.filter_pods(cluster, client)
                # print cluster, len(pods)
            except Exception:
                logging.exception("exception while trying get info from {} cluster".format(cluster))
            else:
                result[cluster] = {}
                result[cluster]["last_upd_time"] = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
                result[cluster]["list_with_broken_vms"] = pods
        return result

    def _process(self):
        self.now_time = datetime.datetime.now()
        self.tmp_cnt_pods = 0
        tmp_broken_vms_for_output = copy.deepcopy(self.broken_vms_for_output)
        self.broken_pods = self.list_vms()
        for cluster in VmagentWatcher.YP_CLUSTERS.keys():
            if cluster in self.broken_pods:
                tmp_broken_vms_for_output[cluster] = copy.deepcopy(self.broken_pods[cluster])
                tmp_lst = tmp_broken_vms_for_output[cluster]["list_with_broken_vms"]
                for i in range(len(tmp_lst)):
                    tmp_lst[i] = helpers.vm_to_dict(tmp_lst[i])

            else:
                self.tmp_cnt_pods += len(tmp_broken_vms_for_output[cluster]["list_with_broken_vms"])
        self.cnt_pods = self.tmp_cnt_pods
        self.broken_vms_for_output = tmp_broken_vms_for_output
        self.prev_bad_state_vms = copy.deepcopy(self.bad_state_vms)
        self.bad_state_vms = []

    def run(self):
        while True:
            logging.info('--------STARTING NEW ITERATION at {}---------'.format(
                datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'))
            )
            try:
                self._process()
            except Exception:
                logging.exception("cathed error in BPods._process")
            finally:
                time.sleep(self.seconds_for_sleep)
