import collections

from tabulate import tabulate

from infra.qyp.vmctl.src.actions.list_helpers import ListField


AVAILABLE_FIELDS = collections.OrderedDict([
    ('node_id', ListField('Node ID')),
    ('cpu', ListField('CPU')),
    ('memory', ListField('Memory')),
    ('hdd', ListField('HDD')),
    ('ssd', ListField('SSD')),
    ('ipv4', ListField('IPv4')),
])


def fetch_free_nodes(args, api_client):
    """
    :type args:
    :type api_client: infra.qyp.vmctl.src.api.VMProxyClient
    :rtype: str
    """
    rsp = api_client.list_free_nodes(cluster=args.yp_cluster, node_segment=args.node_segment)
    div_bytes = 1024 ** 3 if args.pretty else 1
    fields = AVAILABLE_FIELDS.values()
    count = 1
    rows = []
    for node_id, node_data in rsp.free_nodes.iteritems():
        if count > args.limit:
            break
        row = [count, node_id, node_data.cpu, node_data.mem / div_bytes, node_data.disk_per_storage.get('hdd', 0) / div_bytes,
               node_data.disk_per_storage.get('ssd', 0) / div_bytes, node_data.internet_address]
        rows.append(row)
        count += 1
    return rows, ['Index'] + [f.field_name for f in fields]


def run(args, api_client):
    rows, headers = fetch_free_nodes(args, api_client)

    return tabulate(rows, headers=headers, tablefmt='fancy_grid')
