from infra.qyp.proto_lib import vmagent_pb2
from distutils.version import LooseVersion

# Api Client
TIMEOUT = 10
WAIT_ITERATION_TIMEOUT = 10
CREATE_WAIT_ITERATION_TIMEOUT = 30
UPDATE_WAIT_ITERATION_TIMEOUT = 10

CLIENT_ID = '297a7555068648b4b630699441edb4d1'
CLIENT_SECRET = '029edb9acd924dec82496dcf31359a26'

GENCFG_PROXYHOST = 'https://rtc-kvm-vmproxy.n.yandex-team.ru'
VMPROXY_LINK_TPL = "/{path}?host={host}&port={port}&service={service}&pod_id={pod_id}"
DIRECT_LINK = "http://{host}:{port}/{path}?"
LOCAL_TOKEN_PATH = '/tmp/vmagent.token'

# YP Clusters Locations
VMPROXY_LOCATION = {
    'MAN': 'https://vmproxy.man-swat.yandex-team.ru',
    'SAS': 'https://vmproxy.sas-swat.yandex-team.ru',
    'VLA': 'https://vmproxy.vla-swat.yandex-team.ru',
    'IVA': 'https://vmproxy.iva-swat.yandex-team.ru',
    'MYT': 'https://vmproxy.myt-swat.yandex-team.ru',
    'MAN_PRE': 'https://prestable-vmproxy.n.yandex-team.ru',
}
LOCATION_LIST = VMPROXY_LOCATION.keys() + ['ANY']
DEFAULT_LOCATION = 'SAS'  # for gencfg backup
# POD

NODE_SEGMENT_DEV = 'dev'
NODE_SEGMENT_DEFAULT = 'default'
ARM64_SEGMENT_DEV = 'dev-arm64'
NODE_SEGMENTS = [NODE_SEGMENT_DEV, NODE_SEGMENT_DEFAULT, 'gpu-dev', ARM64_SEGMENT_DEV]

NODE_SEGMENT_DEV_DEFAULT_VCPU_LIMIT = 32

# VM
VM_MODE_YP = 'yp'
VM_MODE_GENCFG = 'gencfg'
VM_MODES = [VM_MODE_YP, VM_MODE_GENCFG]

IMAGE_TYPE_RAW = 'RAW'
IMAGE_TYPE_DELTA = 'DELTA'
IMAGE_TYPES = [IMAGE_TYPE_RAW, IMAGE_TYPE_DELTA]

AUDIO_TYPE_NONE = 'NONE'
AUDIO_TYPE_HDA = 'HDA'
AUDIO_TYPES = [AUDIO_TYPE_NONE, AUDIO_TYPE_HDA]

VM_MEMORY_GAP = 1024 ** 3  # 1gb

DISTRO_DICT = {
    "xenial": "rbtorrent:ae5bd8d2f89cb037f6d01bb8390b1e3f1da468c5",
    "xenial-dev": "rbtorrent:5045ff184101ad2126be5647d591f4b890330c0c",
    "bionic": "rbtorrent:1645cc6c97b3d7a14bbfd62db3419ae16f4a5b41",
    "bionic-dev": "rbtorrent:54f87274c2ddb26a93dc6f4b34fdcefa578f5c7e",
    "focal": "rbtorrent:4d16225071a079d9533a35e2399384b47cb103e1",
    "focal-dev": "rbtorrent:e0fb290f044ade4dd49644b7b66195d1ea295f41",
    "xenial-gpu": "rbtorrent:4cc66350cb3d6b905f2238071249c878ddf66bab",
    "bionic-gpu": "rbtorrent:9fb9cc91904ae8d9a6d8aa902b28555baad1cea4",

    # DEPRECATED
    "precise": "rbtorrent:71a005a79d36f2b122432709115697106c77bb59",
    "precise-dev": "rbtorrent:babb72cade990f2169ff046fd5d9d16647cf274c",
    "trusty": "rbtorrent:b84227d2f9a66645def07a81cfbd6f5109379336",
    "trusty-dev": "rbtorrent:38e5e29d6fb4a80528c95c0bc748c84a6031fcf0",
}
GPU_MODELS = (
    'gpu_tesla_k40',
    'gpu_tesla_m40',
    'gpu_tesla_p40',
    'gpu_tesla_v100',
    'gpu_geforce_1080',
    'gpu_geforce_1080ti',
    'gpu_tesla_a100',
)

FINITE_STATES = frozenset([
    vmagent_pb2.VMState.CONFIGURED,
    vmagent_pb2.VMState.STOPPED,
    vmagent_pb2.VMState.RUNNING
])
VMAGENT_BACKUP_VERSION = LooseVersion('0.15')
VMAGENT_QDM_BACKUP_VERSION = LooseVersion('0.26')

VMAGENT_SAFE_UPDATE_VERSION = LooseVersion('0.23')
VMAGENT_UPDATE_WITHOUT_RESTART_VERSION = LooseVersion('0.25')
PERSONAL_ACCOUNT = 'abc:service:4172'

DEFAULT_VOLUME_MP = '/qemu-persistent'

STORAGE_CLASS_HDD = 'hdd'
STORAGE_CLASS_SSD = 'ssd'
STORAGE_CLASSES = [STORAGE_CLASS_HDD, STORAGE_CLASS_SSD]

VM_TYPE_LINUX = 'linux'
VM_TYPE_WINDOWS = 'windows'
VM_TYPES = [VM_TYPE_LINUX, VM_TYPE_WINDOWS]

# Vnc
VNC_LINK = 'https://rtc-kvm-novnc.yandex-team.ru/vnc.html?path=?{path}'
VNC_OFFSET = 3

# Update vmctl links
VMCTL_LINUX_RELEASE_URL = 'https://proxy.sandbox.yandex-team.ru/last/VMCTL_LINUX?attrs={"ttl": "inf"}'
VMCTL_MACOS_RELEASE_URL = 'https://proxy.sandbox.yandex-team.ru/last/VMCTL_MACOS?attrs={"ttl": "inf"}'

VMCTL_LINUX_URL = 'https://proxy.sandbox.yandex-team.ru/last/VMCTL_LINUX'
VMCTL_MACOS_URL = 'https://proxy.sandbox.yandex-team.ru/last/VMCTL_MACOS'

# Confirm Messages
TMP_ACC_WARN_PROMPT = """You are going to use temporary account.
Please, keep in mind, that your VM could be deallocated automatically at any time!
Continue?"""
VM_POWEROFF_PROMPT = """VM will be stopped during this action, all unsaved data will be lost.
Continue?"""
VMAGENT_UPDATE_PROMPT = """Used vmagent version does not support this operation.
Would you like to update vmagent to latest version?"""
VM_BACKUP_FAIL_PROMPT = """Backup action are in progress now. It will fail after VM start.
Continue?"""
OBJECT_REMOVE_PROMPT_TMPL = """{} will be removed.
Continue?"""
DESTRUCTIVE_MSG = "All data in selected virtual machine will be deleted:"
VOLUME_CHANGED_MSG = "All data in changed volumes {volumes_list} will be deleted"
VOLUME_REMOVED_MSG = "Volumes {volumes_list} will be removed, all data will be lost"

VMCTL_FORCE_DIRECT_CONNECTION_ENV_NAME = 'VMCTL_FORCE_DIRECT_CONNECTION'
