class OperationError(Exception):
    """
    Some operation (like modification) failed.
    """
    pass


class DuplicateError(OperationError):
    """
    Attempt to create entity that already exists.
    """
    pass


class NotFoundError(OperationError):
    """
    Requested entity was not found.
    """
    pass


class AuthorizationError(OperationError):
    """
    Authorization settings dissallows this operation.
    """
    pass


class ConcurrentModificationError(OperationError):
    """
    Seems like compare-and-swap operation failed.
    """
    pass


class WrongStateError(OperationError):
    """
    Operation failed because entity is in incompatible state.
    """
    pass


class ValidationError(OperationError):
    """
    Operation failed because prerequisite check failed.
    """
    pass


class InternalError(OperationError):
    """
    Means some invariants expected by underlying system has been broken.
    If you see one of these errors, something is very broken.
    """
    pass
