import json
from sepelib.core import config
import requests
from google.protobuf.json_format import ParseDict
from infra.qyp.proto_lib import accounts_api_pb2


class AccountManagerClient:
    DEFAULT_URL = "https://xdc.qyp.yandex-team.ru"
    DEFAULT_TIMEOUT = 300

    def __init__(self):
        self.oauth_token = config.get_value('account_manager.token')
        self._url = config.get_value('account_manager.url') or self.DEFAULT_URL
        self.timeout = self.DEFAULT_TIMEOUT
        self.headers = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth {}'.format(self.oauth_token)
        }

    def api_call(self, url, data):
        response = requests.post(url, data=json.dumps(data), headers=self.headers, timeout=self.timeout)
        return response

    def request_account_data(self, login, account_id):
        """
        :type login: str
        :type account_id: str
        :rtype: infra.qyp.proto_lib.accounts_api_pb2.ListUserAccountsResponse
        """
        url = self._url + "/ListUserAccounts/"
        data = {'login': login, 'account_id': account_id}
        resp = self.api_call(url, data)
        resp.raise_for_status()
        resp = resp.json()
        accs = accounts_api_pb2.ListUserAccountsResponse()
        ParseDict(resp, accs, ignore_unknown_fields=True)
        return accs
