from infra.swatlib.metrics import InstrumentedSession


class NannyClient(object):
    DEFAULT_URL = 'https://nanny.yandex-team.ru'

    def __init__(self, url=None, token=None):
        if url:
            self._base_url = url.rstrip('/')
        else:
            self._base_url = self.DEFAULT_URL
        self._token = token
        self._session = InstrumentedSession('nanny')
        self._session.headers['Content-Type'] = 'application/json'
        if token:
            self._session.headers['Authorization'] = 'OAuth {}'.format(token)
        self._session.headers['Accept-Encoding'] = ''

    def get_service_owners(self, service_id):
        """
        :type service_id: str
        :rtype: dict
        """
        resp = self._session.get(self._base_url + '/v2/services/{}/auth_attrs'.format(service_id))
        resp.raise_for_status()
        return resp.json()['content']['owners']

    def get_service_instances(self, service_id):
        """
        :type service_id: str
        :rtype: dict
        """
        resp = self._session.get(self._base_url + '/v2/services/{}/current_state/instances'.format(service_id))
        resp.raise_for_status()
        return resp.json()['result']
