from urlparse import urljoin


import gevent
import inject

from infra.swatlib.metrics import InstrumentedSession


class IRtClient(object):
    @classmethod
    def instance(cls):
        return inject.instance(cls)

    def get_project_by_user(self, user):
        """
        :type user: str
        :rtype: list[dict]
        """
        raise NotImplementedError


class RtClient(IRtClient):
    DEFAULT_URL = 'https://ro.racktables.yandex.net/'
    DEFAULT_TIMEOUT = 10

    def __init__(self, url=None, timeout=None):
        """
        :type url: str
        :type timeout: int
        """
        self.url = url or self.DEFAULT_URL
        self.timeout = timeout or self.DEFAULT_TIMEOUT
        self._session = InstrumentedSession('rt')

    def _call(self, method, url, **kwargs):
        with gevent.Timeout(self.timeout):
            resp = self._session.request(method, url, **kwargs)
        resp.raise_for_status()
        return resp

    def get_project_by_user(self, user):
        url = urljoin(self.url, '/export/project-id-by-user.php')
        params = {'login': user, 'show_gencfg': 1}
        return self._call('GET', url, params=params).json()
