import requests
from infra.swatlib.metrics import InstrumentedSession


class VmagentConnectError(Exception):
    pass


class VmagentClient(object):
    DEFAULT_TIMEOUT = 30
    VMAGENT_ID = 2000468

    def __init__(self, tvm_context):
        """
        :type tvm_context: infra.swatlib.auth.tvm.TvmClient
        """
        self._session = InstrumentedSession('vmagent')
        self.tvm_context = tvm_context

    @property
    def auth_headers(self):
        return {'X-Ya-Service-Ticket': self.tvm_context.ticket_to(dst=self.VMAGENT_ID)}

    def _call_remote(self, method, url, data=None):
        try:
            return self._session.request(
                method,
                url,
                data=data,
                headers=self.auth_headers,
                timeout=self.DEFAULT_TIMEOUT
            )
        except requests.RequestException as e:
            raise VmagentConnectError('Could not connect to vmagent: {}'.format(str(e)))

    def action(self, url, data):
        """
        :type url: str
        :type data: str
        :rtype: str
        """
        resp = self._call_remote('POST', url + '/action', data=data)
        resp.raise_for_status()
        return resp.content

    def status(self, url):
        """
        :type url: str
        :rtype: str
        """
        resp = self._call_remote('GET', url + '/status')
        resp.raise_for_status()
        return resp.content

    def debug(self, url, cmd):
        """
        :type url: str
        :type cmd: str
        :rtype: str
        """
        resp = self._call_remote('POST', url + '/debug?cmd=' + cmd)
        resp.raise_for_status()
        return resp.content
