"""
Keep common cli parts in one place.

"""
import argparse
import logging


class CliApp(object):
    log_format = '[%(asctime)s] %(levelname)s %(message)s'
    log_levels = ('CRITICAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG')
    default_loglevel = 'ERROR'

    def __init__(self, args=None):
        super().__init__()
        logging.basicConfig(format=self.log_format, level=logging.DEBUG)
        self.argparser = self.get_argparser(description=self.__doc__)
        self.args = self.argparser.parse_args(args=args)

    def get_argparser(self, description=None):
        parser = argparse.ArgumentParser(description=description)
        parser.add_argument(
            '--loglevel',
            choices=self.log_levels,
            default=self.default_loglevel,
            type=self.set_loglevel,
        )

        return parser

    @staticmethod
    def set_loglevel(level_name):
        logging.getLogger().setLevel(level_name)
        return level_name  # argparser expect value to be returned

    @staticmethod
    def split_arg_enum(arg):
        return sorted(set(filter(lambda x: x != '', arg.split(','))))

    def run(self):
        raise NotImplementedError
