"""
Build conf tree out of structure with declared class names for nodes.

"""
from infra import reconf
from infra.reconf.util import symbols


class DeclaredConf(object):
    """
    Return instance of a class which name provided by get_full_class_name().
    This class should be subclassed.

    """
    def __new__(cls, data, *args, **kwargs):
        class_name = cls.get_full_class_name(data)

        if class_name is None:
            if data:
                raise RuntimeError("class name is not defined")
            else:
                return {}  # trimmed conf

        sym = symbols.SymLoader().load(class_name)

        if not issubclass(sym, reconf.ConfNode):
            raise RuntimeError("class should derive from reconf.ConfNode")

        self = sym.__new__(sym, data, *args, **kwargs)
        self.branches = (cls,)
        self.subnodes = DeclaredConfSet
        self.__init__(data, *args, **kwargs)

        return self

    @staticmethod
    def get_full_class_name(conf):
        """
        Return fully qualified class name (string).
        Should be implemented in derivatives.

        """
        raise NotImplementedError


class DeclaredConfSet(reconf.ConfSet):
    """
    Initialize provided dict using conf factory: DeclaredConf.
    This class should be subclassed.

    """
    def get_endpoint_id(self, origin, conf_class):
        return origin  # keep unchanged (ready)

    def get_node_id(self, origin, conf_class):
        return origin  # keep unchanged (ready)
