"""
Canonized tests examples.

To have access to `diff_canonized` and other fixtures mentioned here just add
`infra/reconf/pytest` to PEERDIR

"""
import json


def test__diff_canonized__fixture_example(diff_canonized):
    result = {'arbitrary': {'json': ['serializable', 'structure']}}
    serialized_result = json.dumps(result)

    # Serialized result will be compared with canonized value and, if they
    # are not equal, test will be marked failed and human readable diff
    # printed.
    #
    # To canonize new result run `ya make -tA --test-param canonize-output=1`
    #
    # Canonized data is a part of test and should be committed together with
    # code producing testing results.
    diff_canonized(serialized_result)
