import os

import yatest.common


def canonized_data_dir(request):
    """
    Return path to canonizing data directory for current test function.

    """
    return os.path.join(
        yatest.common.test_source_path(),
        'canondata',
        request.module.__name__.rsplit('.', 1)[-1] + '.' +
        request.function.__name__
    )


def canonized(request, given, file_name='data', param_key='canonize-output'):
    """
    Get (and optionally update) canonized data for test function.

    We don't use ya-tool's canonizing facilities here because of conflicts in
    `canondata/result.json`, see https://st.yandex-team.ru/RUNTIMECLOUD-14129

    """
    canonizing = yatest.common.get_param(param_key, False)
    dir_name = canonized_data_dir(request)
    file_name = os.path.join(dir_name, file_name)

    if canonizing:
        os.makedirs(dir_name, exist_ok=True)
        with open(file_name, 'w') as f:
            f.write(given)
        return given

    try:
        with open(file_name) as f:
            return f.read()
    except FileNotFoundError:
        __tracebackhide__ = True
        raise FileNotFoundError(
            'Results should be canonized first, run ya make -tA --test-param '
            + param_key + '=1'
        ) from None


def assert_canonized(request, given, **kwargs):
    """
    Naive pytest-style assert with canonization.

    """
    __tracebackhide__ = True
    assert canonized(request, given, **kwargs) == given
