import json
import os
import pytest
import yatest.common

from infra.reconf.pytest.canonized import canonized
from infra.reconf.util.diff import nested


@pytest.fixture
def diff_canonized(request):
    """
    Diff given data with canonized one.

    To canonize run `ya make -tA --test-param canonize-output=1`

    """
    def _differ(given, fmt='json'):
        expected = canonized(request, given, file_name='output')

        if fmt == 'json':
            expected = json.loads(expected)
            given = json.loads(given)
        else:
            raise NotImplementedError('Unsupported canonizing format: ' + fmt)

        diff, equal = nested(expected, given, term_colors=True)

        if not equal:
            __tracebackhide__ = True
            pytest.fail('different from canonical data\033[0m\n' + diff)

    return _differ


@pytest.fixture
def file_in_test_dir():
    def _abs_path_in_test_dir(name):
        return os.path.join(yatest.common.test_source_path(), name)

    return _abs_path_in_test_dir
