"""
Collection of differs for nested structures.

"""
import json
import nested_diff
import nested_diff.fmt
import subprocess
import tempfile


def nested(old, new, sort_keys=True, term_colors=False):
    """
    Rerturn text/term formatted nested diff and equality flag.

    """
    diff = nested_diff.diff(old, new, U=False)
    equal = True if not diff or 'U' in diff else False

    if term_colors:
        formatter = nested_diff.fmt.TermFormatter(sort_keys=sort_keys)
    else:
        formatter = nested_diff.fmt.TextFormatter(sort_keys=sort_keys)

    return formatter.format(diff), equal


def unified(old, new, context=10):
    """
    Return unified diff for JSON serialized structures.

    This function is deprecated.

    """
    old_fp = tempfile.NamedTemporaryFile(mode='w')
    new_fp = tempfile.NamedTemporaryFile(mode='w')

    json.dump(old, old_fp, indent=3, sort_keys=True)
    json.dump(new, new_fp, indent=3, sort_keys=True)

    old_fp.flush()
    new_fp.flush()

    # had tried difflib.unified_diff here, but without luck; details in
    # https://st.yandex-team.ru/RUNTIMECLOUD-13921#5d4a919ea2b79e001cd83102
    try:
        text = subprocess.check_output(
            ['diff', '--unified=' + str(context), old_fp.name, new_fp.name],
            universal_newlines=True,
        )
        equal = True
    except subprocess.CalledProcessError as e:
        if e.returncode == 1:  # all went ok, diff exists
            text = str(e.output)
            equal = False
        else:
            raise

    return text, equal
