import importlib


class SymLoader(object):
    """ Run-time python symbols loader. """
    def __init__(self):
        self.__cache = {}
        self.__modules = {}

    def load(self, symbol_full_name):
        """
        Load arbitrary symbol from python module.

        Example:
            cls = SymLoader().load('infra.reconf.util.handled.HandledDict')
        """
        if symbol_full_name not in self.__cache:
            mod_name, sym_name = symbol_full_name.rsplit('.', 1)

            if mod_name not in self.__modules:
                self.__modules[mod_name] = importlib.import_module(mod_name)

            self.__cache[symbol_full_name] = getattr(self.__modules[mod_name],
                                                     sym_name)

        return self.__cache[symbol_full_name]


def symbol_full_name(symbol):
    """ Return string with full name in dotted format. """
    return symbol.__module__ + '.' + symbol.__name__
