from infra.reconf_juggler import Check
from infra.reconf_juggler.opts import actives, aggregators


class AbstractInfraCheck(Check):
    """
    Base class for infrastructure checks such as ssh, cron and so on.

    """
    _aggregator = aggregators.SelectiveAggregator


class AbstractUnreachCheck(Check):
    """
    Base class for all unreachable checks (for cases when host can't be
    monitored at all).

    """
    _aggregator = aggregators.SelectiveAggregator

    category = 'unreach'


class UNREACHABLE(AbstractUnreachCheck):
    """
    Check host network availability (ping from juggler servers)

    """
    _active = actives.UNREACHABLE


class META(AbstractUnreachCheck):
    """
    Ensure we have fresh results for passive checks

    """
    _unreach_service_classes = (UNREACHABLE,)


class ssh(AbstractInfraCheck):
    """
    Check SSH daemon accept connections

    """
    _active = actives.ssh
    _unreach_service_classes = (AbstractUnreachCheck,)

    category = 'infra'
