"""
Build check tree out of structure with declared class names for nodes.

"""
from infra.reconf.declarative import DeclaredConf, DeclaredConfSet


class DeclaredCheck(DeclaredConf):
    """
    Factory: return instance of a class written in ['meta']['reconf']['class'].

    """
    @staticmethod
    def get_full_class_name(conf):
        try:
            return conf['meta']['reconf']['class']
        except KeyError:
            return None


class DeclaredCheckSet(DeclaredConfSet):
    """
    Initialize provided dict using check-factory - DeclaredCheck.

    """
    branches = (DeclaredCheck,)


# attrs indirect recursion doesn't allowed in classes definition
DeclaredCheck.subnodes = DeclaredCheckSet
