from infra.reconf_juggler.builders import DeclaredChecksBuilder


class Builder(DeclaredChecksBuilder):
    default_check_class = 'infra.reconf_juggler.checks.AbstractUnreachCheck'

    def build_initial_tree(self, initial_data):
        return {
            'all:alive': {
                'children': {
                    'all:ping': {
                        'children': {
                            'rtc:UNREACHABLE': {},
                            'yp:UNREACHABLE': {},
                        },
                    },
                    'all:sshd': {
                        'children': {
                            'rtc:ssh': {},  # existing aggregate
                            'yp:ssh': {},
                            'example.yandex.ru:ssh': None,  # single host
                        },
                        'meta': {
                            'reconf': {
                                # define exact class for aggregate
                                'class': 'infra.reconf_juggler.checks.ssh',
                            },
                        },
                    },
                },
            },
        }


def main():
    Builder().run(app_desc=__doc__)
