from infra.reconf_juggler import Check, CheckSet
from infra.reconf_juggler.builders import JugglerChecksBuilder
from infra.reconf_juggler.opts import actives, aggregators
from infra.reconf_juggler.trees import NodeSet


class HttpActiveOpts(actives.ActiveHandler):
    @staticmethod
    def get_defaults():
        return {
            'active' : 'http',
            'active_kwargs' : {
                'ok_codes' : 200,
                'path' : 'ping',
                'substr' : 'pong',
            },
        }


class http(Check):
    """
    Ensure daemon serve http requests.

    """
    _active = HttpActiveOpts
    _aggregator = aggregators.SelectiveAggregator


class SimpleChecksSet(CheckSet):
    branches = (http,)  # tuple


class Builder(JugglerChecksBuilder):
    def build_initial_tree(self, initial_data):
        return NodeSet(
            {
                'production_imgsbase_sas': {
                    'children': {'NANNY%production_imgsbase_sas': None},
                    'tags': ['oops', 'front'],
                },
            },
        )

    def build_checks_tree(self, initial_tree):
        return SimpleChecksSet(initial_tree, resolver=self.resolver)


def main():
    Builder().run(app_desc=__doc__)
