from infra.reconf import ConfOptAbsent
from infra.reconf_juggler.opts import CheckOptHandler


class ActiveHandler(CheckOptHandler):
    @staticmethod
    def get_defaults():
        return {
            'active': None,
            'active_kwargs': None,
        }

    def get_default_value(self, key):
        # Return defined opt values for aggregates with real instances only
        if not self._bound.has_subnodes() or self._bound.has_endpoints():
            value = super().get_default_value(key)
            if value is not None:
                return value

        raise ConfOptAbsent


class UNREACHABLE(ActiveHandler):
    @staticmethod
    def get_defaults():
        return {
            'active': 'icmpping',
            'active_kwargs': None,
        }


class ssh(ActiveHandler):
    @staticmethod
    def get_defaults():
        return {
            'active': 'ssh',
            'active_kwargs': {
                'timeout': 40
            }
        }


class rsync(ActiveHandler):
    @staticmethod
    def get_defaults():
        return {
            'active': 'rsync',
            'active_kwargs': {
                'timeout': 15
            }
        }
