from infra.reconf import ConfOptAbsent
from infra.reconf_juggler.opts import CheckOptHandler


class FlapHandler(CheckOptHandler):
    @staticmethod
    def get_defaults():
        return {
            'flaps': {
                'critical': None,
                'boost': None,
                'stable': None,
            }
        }

    def get_default_value(self, key):
        if self._bound.has_subnodes():
            # Do not set on metaagregates: flaps suppressed on raw events
            # level, so it is at least useless here. Even if flap works with
            # aggregates for children, it will do more harm than good - will
            # cause cascade flaps suppressing (unpredictable alerts delay) in
            # worst case
            raise ConfOptAbsent

        value = super().get_default_value(key)

        # Juggler has two "defaults" for flap detector:
        # 1. detector disabled when aggregate has no 'flaps' at all
        # 2. flaps opts defaults will be set when 'flaps' passed as empty dict
        # or it's opts have `None` values
        # https://st.yandex-team.ru/RUNTIMECLOUD-14267#5d690d14a2b79e001d656f8f
        for v in value.values():
            if v is not None:
                return value

        raise ConfOptAbsent
