from infra.reconf.util.symbols import symbol_full_name
from infra.reconf_juggler.opts import CheckOptHandler


class MetaHandler(CheckOptHandler):
    @staticmethod
    def get_defaults():
        return {'meta': {}}

    def get_default_value(self, key):
        data = {'reconf': {'class': symbol_full_name(self._bound.__class__)}}

        if self._bound.doc_url is not None:
            data['urls'] = [{
                'title': 'Docs',
                'type': 'doc_url',
                'url': self._bound.doc_url,
            }]

        return data

    def get_handled_value(self, key, val):
        ret = self.get_default_value(key)

        if 'urls' in val:
            ret.setdefault('urls', []).extend(val['urls'])

        return ret
