from infra.reconf_juggler.opts import CheckOptHandler


class NotificationsHandler(CheckOptHandler):
    notify_rules = ()

    @staticmethod
    def get_defaults():
        return {'notifications': []}

    def get_default_value(self, key):
        val = super().get_default_value(key)

        if key == 'notifications':
            for rule in self.notify_rules:
                if rule not in val:
                    val.append(rule)

        return val
