from infra.reconf import ConfOptAbsent
from infra.reconf_juggler.opts import CheckOptHandler


class OptionsHandler(CheckOptHandler):
    @staticmethod
    def get_defaults():
        return {'check_options': None}

    def get_default_value(self, key):
        if not self._bound.has_subnodes() or self._bound.has_endpoints():
            return super().get_default_value(key)

        raise ConfOptAbsent
