import os
import pytest
import yatest.common

from infra.reconf.pytest.canonized import canonized_data_dir
from infra.reconf_juggler.resolvers import RootResolver


class CanonizedResolver(RootResolver):
    pass


@pytest.fixture
def canonized_resolver(request):
    """
    Return canonized resolver instance.

    To re-capture and canonize resolver data run
    `ya make -tA --test-param canonize-input=1`

    """
    file_name = os.path.join(canonized_data_dir(request), 'input')
    resolver = CanonizedResolver()

    canonizing = any((
        yatest.common.get_param('canonize-input', False),
        yatest.common.get_param('canonize-resolved', False),  # back compat
    ))

    if canonizing:
        resolver.set_mode(use_cache=True, use_fetch=True, propagate=True)
    else:
        if os.path.exists(file_name):
            resolver.load_cache_from_file(file_name)

        resolver.set_mode(use_cache=True, use_fetch=False, propagate=True)

    yield resolver

    if canonizing:
        resolver.dump_cache_to_file(file_name)
