from infra.reconf_juggler.trees import Node, NodeSet


class Location(Node):
    @classmethod
    def get_selectors(cls):
        return {'datacenter': cls.__name__.lower()}

    @classmethod
    def get_name_suffix(cls):
        return '_' + cls.__name__.lower()

    @classmethod
    def get_tags(cls):
        return ['geo_' + cls.__name__.lower()]


class Datacenter(Location):
    @classmethod
    def get_tags(cls):
        return ['dc_' + cls.__name__.lower()]


class IVA(Datacenter):
    pass


class MYT(Datacenter):
    pass


class MSKDatacentersSet(NodeSet):
    branches = (
        IVA,
        MYT,
    )


class MAN(Location):
    pass


class MSK(Location):
    subnodes = MSKDatacentersSet


class SAS(Location):
    pass


class VLA(Location):
    pass


class LocationsSet(NodeSet):
    branches = (
        MAN,
        MSK,
        SAS,
        VLA,
    )


class LocationsRoot(Node):
    """
    Build tree for provided groups following location/dc structure.

    """
    subnodes = LocationsSet


class Locations(NodeSet):
    branches = (LocationsRoot,)
