"""
D3js visualisation stuff, st/HOSTMAN-489

"""


def convert(checkset, root_name='root'):
    """
    Convert CheckSet to d3js hierarchy format.

    :param checks: reconf.juggler.CheckSet instance.

    """
    children = []

    for name, body in sorted(checkset.items()):
        if body is None:  # group selector
            children.append({'name': name})
        else:
            children.append(convert(body.get('children', {}), root_name=name))

    if children:
        return {'name': root_name, 'children': children}

    return {'name': root_name}
