from __future__ import unicode_literals

import yp.data_model

from infra.release_controller.src import releaseutil


class DeployTicketMaker(object):

    DEPLOY_TICKET_TITLE_TEMPLATE = "Created from release {} and release rule {}"

    @staticmethod
    def make_deploy_ticket_id(release, release_rule):
        return '{}-{}'.format(release.meta.id, release_rule.meta.id)

    @classmethod
    def make_deploy_ticket_title(cls, release, release_rule):
        return cls.DEPLOY_TICKET_TITLE_TEMPLATE.format(release.meta.id,
                                                       release_rule.meta.id)

    @classmethod
    def make_deploy_ticket(cls, release, release_rule, stage):
        ticket = yp.data_model.TDeployTicket()
        ticket.meta.id = cls.make_deploy_ticket_id(release, release_rule)
        ticket.meta.stage_id = release_rule.meta.stage_id
        spec = ticket.spec
        status = ticket.status
        patch_status = yp.data_model.TDeployPatchStatus()
        rule_docker = releaseutil.is_rule_docker(release_rule)
        rule_multi_docker = releaseutil.is_rule_multi_docker(release_rule)
        image_name = release_rule.spec.docker.image_name
        for patch_name, patch in release_rule.spec.patches.iteritems():
            spec.patches[patch_name].CopyFrom(patch)
            if rule_docker and not rule_multi_docker:
                spec.patches[patch_name].docker.image_name = image_name
            status.patches[patch_name].CopyFrom(patch_status)
        title = cls.make_deploy_ticket_title(release, release_rule)
        spec.title = title
        spec.description = title
        spec.responsibles.extend(release_rule.spec.responsibles)
        spec.release_id = release.meta.id
        spec.release_rule_id = release_rule.meta.id
        return ticket
