from __future__ import unicode_literals

import yp.data_model


def set_condition(cond, status, reason, message):
    if cond.status != status:
        cond.last_transition_time.GetCurrentTime()
    cond.status = status
    cond.reason = reason
    cond.reason = reason


def set_condition_success(cond, message, reason='OK'):
    set_condition(cond, yp.data_model.CS_TRUE, reason, message)


def set_condition_failed(cond, message, reason='FAILED'):
    set_condition(cond, yp.data_model.CS_FALSE, reason, message)


def set_condition_exception(cond, exc, reason='FAILED'):
    set_condition(cond, yp.data_model.CS_FALSE, reason, str(exc))
