from __future__ import unicode_literals

import yt_yson_bindings


class YsonObjectLoader(object):

    @staticmethod
    def make_attr_paths(selectors):
        return tuple(s.strip("/").split("/") for s in selectors)

    @staticmethod
    def make_object_attr(obj, attr_path):
        attr = obj
        for attr_name in attr_path:
            if attr_name:
                attr = getattr(attr, attr_name)
        return attr

    def load_object_attrs(self, obj_class, paths, value_payloads):
        obj = obj_class()
        for i in xrange(len(paths)):
            attr = self.make_object_attr(obj, paths[i])
            yson_v = value_payloads[i].yson
            o = yt_yson_bindings.loads_proto(yson_v, type(attr),
                                             skip_unknown_fields=True)
            attr.CopyFrom(o)
        return obj

    def load_object(self, obj_class, selectors, value_payloads):
        paths = self.make_attr_paths(selectors)
        return self.load_object_attrs(obj_class, paths, value_payloads)


def is_release_rule_sandbox(release_rule):
    return release_rule.spec.WhichOneof('selector') == 'sandbox'


def is_release_rule_docker(release_rule):
    return release_rule.spec.WhichOneof('selector') == 'docker'


def is_stage_sandbox(stage):
    # TODO: implement it
    return True


def is_stage_docker(stage):
    # TODO: implement it
    return False


YSON_LOADER = YsonObjectLoader()
