from __future__ import unicode_literals
import collections

from infra.release_controller.src import consts
from infra.release_controller.src.lib import yputil


class Storage(object):
    def __init__(self):
        self.data = {}
        self.indexers = {}
        self.indices = collections.defaultdict(set)

    def get(self, obj_id):
        return self.data.get(obj_id)

    def add(self, obj):
        obj_id = obj.meta.id
        self.data[obj_id] = obj
        index_matches = 0
        for index_name, indexer in self.indexers.iteritems():
            if indexer(obj):
                self.indices[index_name].add(obj_id)
                index_matches += 1
        return index_matches

    def list(self, count=None):
        rv = []
        for obj in self.data.itervalues():
            if count is not None and len(rv) == count:
                break
            rv.append(obj)
        return rv

    def list_by_index(self, index_name, count=None):
        rv = []
        idx = self.indices[index_name]
        for obj_id in idx:
            if count is not None and len(rv) == count:
                break
            obj = self.get(obj_id)
            if obj is not None:
                rv.append(obj)
        return rv

    def count(self):
        return len(self.data)

    def add_indexer(self, index_name, indexer):
        self.indexers[index_name] = indexer

    def update_from_other_storage(self, s):
        self.data = s.data
        self.indexers = s.indexers
        self.indices = s.indices


RELEASE_RULE_INDEXERS = {
    consts.SANDBOX_INDEX_NAME: yputil.is_release_rule_sandbox,
    consts.DOCKER_INDEX_NAME: yputil.is_release_rule_docker,
}

STAGE_INDEXERS = {
    consts.SANDBOX_INDEX_NAME: yputil.is_stage_sandbox,
    consts.DOCKER_INDEX_NAME: yputil.is_stage_docker,
}


def make_storage(indexers):
    rv = Storage()
    for index_name, indexer in indexers.iteritems():
        rv.add_indexer(index_name, indexer)
    return rv
