from __future__ import unicode_literals
import os
import sys

import yp.client
import yp.common
import yp.data_model
import yt.yson as yson
import yt_yson_bindings
from yp_proto.yp.client.api.proto import object_service_pb2


CLUSTER = 'xdc'
RELEASE_ID = '__BUILD_DCTL_ACTUAL__'
RELEASE_AUTHOR = 'robot-yd-releaser'

RELEASERS = [
    'alonger',
    'reddi',
    RELEASE_AUTHOR
]

CLUSTERS = {
    'xdc': 'xdc.yp.yandex.net:8090',
    'sas-test': 'sas-test.yp.yandex.net:8090',
}

SVN_REVISION_LABEL = 'svn_revision'


def make_stub(cluster):
    token = os.getenv('YP_OAUTH_TOKEN')
    if not token:
        raise ValueError('Put your token to YP_OAUTH_TOKEN env var')
    base_client = yp.client.YpClient(address=CLUSTERS[cluster],
                                     config={'token': token})
    return base_client.create_grpc_object_stub()


def set_label(labels, key, value):
    attr = None
    for a in labels.attributes:
        if a.key == key:
            attr = a
            break
    if attr is None:
        attr = labels.attributes.add()
        attr.key = key
    attr.value = yson.dumps(value)


def set_release_acl(release, releasers):
    del release.meta.acl[:]
    for r in releasers:
        e = release.meta.acl.add()
        e.permissions.append(yp.data_model.ACA_WRITE)
        e.action = yp.data_model.ACA_ALLOW
        e.subjects.append(r)


def make_init_release(release_id, build_id, task_id, release_author, releasers):
    r = yp.data_model.TRelease()
    r.meta.id = release_id
    set_label(r.labels, SVN_REVISION_LABEL, build_id)
    set_release_acl(r, releasers)
    r.spec.sandbox.task_id = task_id
    r.spec.sandbox.task_type = 'BUILD_ARCADIA_PROJECT_FOR_ALL'
    r.spec.sandbox.release_type = 'stable'
    r.spec.sandbox.release_author = release_author
    resource = r.spec.sandbox.resources.add()
    resource.resource_id = '1407157499'
    resource.type = 'ARCADIA_PROJECT_TGZ'
    resource.skynet_id = 'rbtorrent:1bb73c36a2074bf7aeb8f1dce0f1aa81a00d40f5'
    r.status.processing.finished.status = yp.data_model.CS_TRUE
    return r


def create_release(cluster, release_id, build_id, task_id, release_author, releasers):
    stub = make_stub(cluster)
    req = object_service_pb2.TReqCreateObject()
    req.object_type = yp.data_model.OT_RELEASE
    r = make_init_release(release_id, build_id, task_id, release_author, releasers)
    req.attributes = yt_yson_bindings.dumps_proto(r)
    stub.CreateObject(req)


def update_release(cluster, release_id, build_id, task_id):
    stub = make_stub(cluster)
    req = object_service_pb2.TReqUpdateObject()
    req.object_type = yp.data_model.OT_RELEASE
    req.object_id = release_id
    upd = req.set_updates.add()
    upd.path = '/labels/{}'.format(SVN_REVISION_LABEL)
    upd.value = yson.dumps(build_id)
    upd = req.set_updates.add()
    upd.path = '/spec/sandbox/task_id'
    upd.value = yson.dumps(task_id)
    stub.UpdateObject(req)


def update_release_acl(cluster, release_id, releasers):
    stub = make_stub(cluster)
    r = yp.data_model.TRelease()
    set_release_acl(r, releasers)
    req = object_service_pb2.TReqUpdateObject()
    req.object_type = yp.data_model.OT_RELEASE
    req.object_id = release_id
    upd = req.set_updates.add()
    upd.path = '/meta'
    upd.value = yt_yson_bindings.dumps_proto(r.meta)
    stub.UpdateObject(req)


def create_or_update_release(cluster, release_id, build_id, task_id, release_author, releasers):
    try:
        create_release(cluster, release_id, build_id, task_id, release_author, releasers)
    except yp.common.YpDuplicateObjectIdError:
        update_release(cluster, release_id, build_id, task_id)


if __name__ == '__main__':
    cluster = 'xdc'
    release_id = '__BUILD_DCTL_ACTUAL__'
    release_author = 'robot-yd-releaser'
    act = sys.argv[1]
    if act == 'update_releasers':
        update_release_acl(cluster, release_id, RELEASERS)
    elif act == 'release':
        build_id = sys.argv[2]
        task_id = sys.argv[3]
        create_or_update_release(cluster, release_id, build_id, task_id, release_author, RELEASERS)
    else:
        raise ValueError('Unknown action: "{}"'.format(act))
