from __future__ import unicode_literals

import yp.data_model

from infra.release_status_controller.src.lib import pbutil
from infra.release_status_controller.src.lib import progressutil
from infra.release_status_controller.src.lib import yputil


class AggregatedProgress(object):

    def __init__(self):
        self.is_empty = True
        self.in_progress = False
        self.closed = True

    def update(self, is_empty, in_progress, closed):
        if self.in_progress:
            return
        self.is_empty = self.is_empty and is_empty
        self.closed = self.closed and closed
        if in_progress or not self.is_empty and not self.closed:
            self.in_progress = True
            self.is_empty = False
            self.closed = False

    def update_by_patch_progress(self, progress):
        self.update(is_empty=yputil.is_patch_progress_empty(progress),
                    in_progress=pbutil.is_condition_true(progress.in_progress),
                    closed=yputil.is_patch_progress_closed(progress))

    def update_by_ticket_progress(self, progress):
        self.update(is_empty=yputil.is_progress_empty(progress),
                    in_progress=pbutil.is_condition_true(progress.in_progress),
                    closed=pbutil.is_condition_true(progress.closed))

    def _fill_progress(self, progress, in_progress_message, closed_message, start_time):
        if self.is_empty:
            return
        if self.in_progress:
            progressutil.set_in_progress(progress,
                                         message=in_progress_message,
                                         start_time=start_time)
        if self.closed:
            progressutil.set_closed(progress,
                                    message=closed_message,
                                    start_time=start_time)

    def make_ticket_progress(self, status):
        p = yp.data_model.TDeployTicketProgress()
        self._fill_progress(progress=p,
                            in_progress_message='Some patches are in progress',
                            closed_message='All patches are closed',
                            start_time=status.progress.start_time)
        return p

    def make_release_progress(self, status):
        p = yp.data_model.TReleaseProgress()
        self._fill_progress(progress=p,
                            in_progress_message='Some tickets are in progress',
                            closed_message='All tickets are closed',
                            start_time=status.progress.start_time)
        return p
