from __future__ import unicode_literals

from infra.swatlib.gevent import geventutil as gutil
from infra.release_status_controller.src.lib import pbutil


class DeployProgressMaker(object):
    @staticmethod
    def _is_ticket_cancelled(ticket_status):
        return any(
            pbutil.is_condition_true(patch.progress.cancelled)
            or pbutil.is_condition_true(patch.progress.failed)
            for patch in gutil.gevent_idle_iter(ticket_status.patches.itervalues())
        )

    @staticmethod
    def _collect_affected_dus_and_drs(ticket_spec):
        deploy_units = set()
        dynamic_resources = set()

        for patch in gutil.gevent_idle_iter(ticket_spec.patches.itervalues()):
            patch_kind = patch.WhichOneof('payload')
            if patch_kind == 'sandbox':
                sb = patch.sandbox
                sb_ref = sb.WhichOneof('resource_ref')
                if sb_ref == 'static':
                    deploy_units.add(sb.static.deploy_unit_id)
                elif sb_ref == 'dynamic':
                    dynamic_resources.add(sb.dynamic.dynamic_resource_id)
            elif patch_kind == 'docker':
                deploy_units.add(patch.docker.docker_image_ref.deploy_unit_id)
            elif patch_kind == 'resource_bundle':
                if patch.resource_bundle.WhichOneof('resource_bundle_ref') == 'static':
                    deploy_units.add(patch.resource_bundle.static.deploy_unit_id)

        return deploy_units, dynamic_resources

    @staticmethod
    def make_deploy_progress(stage, ticket, status):
        if DeployProgressMaker._is_ticket_cancelled(status):
            return

        deploy_units, dynamic_resources = DeployProgressMaker._collect_affected_dus_and_drs(ticket.spec)
        for du in deploy_units:
            du_status = stage.status.deploy_units[du]
            rs_kind = du_status.WhichOneof('details')
            if rs_kind != 'replica_set':
                continue

            du_progress = du_status.replica_set.cluster_statuses

            for cluster, cluster_progress in gutil.gevent_idle_iter(du_progress.iteritems()):
                status.progress.cluster_statuses[cluster].progress.pods_in_progress += cluster_progress.status.deploy_status.details.current_revision_progress.pods_in_progress
                status.progress.cluster_statuses[cluster].progress.pods_ready += cluster_progress.status.deploy_status.details.current_revision_progress.pods_ready
                status.progress.cluster_statuses[cluster].progress.pods_total += cluster_progress.status.deploy_status.details.current_revision_progress.pods_total
                status.progress.cluster_statuses[cluster].progress.pods_failed += cluster_progress.status.deploy_status.details.current_revision_progress.pods_failed
                if pbutil.is_condition_true(cluster_progress.status.in_progress_condition):
                    status.progress.cluster_statuses[cluster].in_progress.CopyFrom(cluster_progress.status.in_progress_condition)
                    status.progress.cluster_statuses[cluster].ready.Clear()
                if (
                    pbutil.is_condition_true(cluster_progress.status.ready_condition)
                    and not pbutil.is_condition_true(status.progress.cluster_statuses[cluster].in_progress)
                ):
                    status.progress.cluster_statuses[cluster].ready.CopyFrom(cluster_progress.status.ready_condition)
