from __future__ import unicode_literals

import yp.data_model


def is_timestamp_set(timestamp):
    return timestamp.seconds or timestamp.nanos


def set_condition(cond, status, reason, message):
    if cond.status != status:
        cond.last_transition_time.GetCurrentTime()
    cond.status = status
    cond.reason = reason
    cond.message = message


def set_true_condition(cond, reason, message):
    set_condition(cond, yp.data_model.CS_TRUE, reason, message)


def is_condition_true(cond):
    return cond.status == yp.data_model.CS_TRUE


def is_condition_unknown(cond):
    return cond.status == yp.data_model.CS_UNKNOWN


def condition_changed(old_cond, new_cond):
    return old_cond.status != new_cond.status
