from __future__ import unicode_literals

from infra.release_status_controller.src.lib import pbutil


PATCH_SUCCESS_MESSAGE = 'Patch deployed successfully'

PATCH_IN_PROGRESS_MESSAGE = 'Patch deploy is in progress'

PATCH_FAILED_MESSAGE = 'Patch deploy has some errors'


def set_start_time(p, start_time, current_time):
    if pbutil.is_timestamp_set(start_time):
        p.start_time.CopyFrom(start_time)
    else:
        p.start_time.CopyFrom(current_time)


def set_time_range(p, start_time, end_time):
    p.end_time.CopyFrom(end_time)
    set_start_time(p, start_time, end_time)


def set_pending(p, message):
    pbutil.set_true_condition(p.pending,
                              reason='PENDING',
                              message=message)


def make_patch_progress_message(prefix, condition):
    if not condition.message:
        return prefix
    return '{}: {}'.format(prefix, condition.message)


def set_in_progress(p, message, start_time):
    pbutil.set_true_condition(p.in_progress,
                              reason='IN_PROGRESS',
                              message=message)
    set_start_time(p, start_time=start_time, current_time=p.in_progress.last_transition_time)


def set_in_progress_from_condition(p, condition, start_time):
    message = make_patch_progress_message(PATCH_IN_PROGRESS_MESSAGE, condition)
    set_in_progress(p, message, start_time)


def set_success_from_condition(p, condition, start_time):
    message = make_patch_progress_message(PATCH_SUCCESS_MESSAGE, condition)
    pbutil.set_true_condition(p.success,
                              reason='SUCCESS',
                              message=message)
    set_time_range(p, start_time=start_time, end_time=p.success.last_transition_time)


def set_failed_from_condition(p, condition, start_time):
    message = make_patch_progress_message(PATCH_FAILED_MESSAGE, condition)
    pbutil.set_true_condition(p.failed,
                              reason='FAILED',
                              message=message)
    set_time_range(p, start_time=start_time, end_time=p.failed.last_transition_time)


def set_cancelled(p, message, start_time):
    pbutil.set_true_condition(p.cancelled,
                              reason='CANCELLED',
                              message=message)
    set_time_range(p, start_time=start_time, end_time=p.cancelled.last_transition_time)


def set_closed(p, message, start_time):
    pbutil.set_true_condition(p.closed,
                              reason='CLOSED',
                              message=message)
    set_time_range(p, start_time=start_time, end_time=p.closed.last_transition_time)
