from __future__ import unicode_literals
import collections


class Index(object):
    def __init__(self):
        self.data = collections.defaultdict(set)

    def add(self, key, value):
        self.data[key].add(value)

    def find(self, key):
        return self.data[key]


class Storage(object):
    def __init__(self):
        self.data = {}
        self.indexers = {}
        self.indices = collections.defaultdict(Index)

    def get(self, key):
        return self.data.get(key)

    def add(self, key, obj):
        self.data[key] = obj
        index_matches = 0
        for index_name, indexer in self.indexers.iteritems():
            indexed = indexer(obj)
            if indexed:
                self.indices[index_name].add(key=indexed, value=key)
                index_matches += 1
        return index_matches

    def list(self, count=None):
        rv = []
        for obj in self.data.itervalues():
            if count is not None and len(rv) == count:
                break
            rv.append(obj)
        return rv

    def find_in_index(self, index_name, indexed, count=None):
        rv = []
        idx = self.indices[index_name]
        for obj_key in idx.find(key=indexed):
            if count is not None and len(rv) == count:
                break
            obj = self.get(obj_key)
            if obj is not None:
                rv.append(obj)
        return rv

    def count(self):
        return len(self.data)

    def add_indexer(self, index_name, indexer):
        self.indexers[index_name] = indexer

    def update_from_other_storage(self, s):
        self.data = s.data
        self.indexers = s.indexers
        self.indices = s.indices


def get_default_key_for_object(obj):
    return obj.meta.id


def get_default_key_for_object_with_timestamp(obj):
    o, _ = obj
    return get_default_key_for_object(o)


def make_storage(indexers=None):
    indexers = indexers or {}
    rv = Storage()
    for index_name, indexer in indexers.iteritems():
        rv.add_indexer(index_name, indexer)
    return rv
