from __future__ import unicode_literals


class PatchAppliedCache(object):

    def __init__(self):
        self._cache = {}

    def get(self, patch_name, release_id, stage_id, stage_spec_ts):
        key = (stage_id, patch_name, release_id)
        r = self._cache.get(key)
        if not r:
            return None, False
        is_applied, cached_spec_ts = r
        if stage_spec_ts == cached_spec_ts:
            return is_applied, True
        self._cache.pop(key, None)
        return None, False

    def set(self, patch_name, release_id, stage_id, stage_spec_ts, is_applied):
        key = (stage_id, patch_name, release_id)
        self._cache[key] = is_applied, stage_spec_ts
