from __future__ import unicode_literals

import yp.data_model

from infra.swatlib.gevent import geventutil as gutil
from infra.release_status_controller.src import aggregated_progress
from infra.release_status_controller.src.lib import yputil


class TicketStatusMaker(object):

    SPEC_SELECTOR = '/spec'

    def __init__(self, patch_progress_maker, deploy_progress_maker, stage_storage):
        self.patch_progress_maker = patch_progress_maker
        self.deploy_progress_maker = deploy_progress_maker
        self.stage_storage = stage_storage

    def make_ticket_status(self, ticket, release):
        status = yp.data_model.TDeployTicketStatus()
        stage, timestamps = self.stage_storage.get(ticket.meta.stage_id)
        spec_ts = timestamps[self.SPEC_SELECTOR]
        agg = aggregated_progress.AggregatedProgress()
        changed = False
        for name, patch_spec in gutil.gevent_idle_iter(ticket.spec.patches.iteritems()):
            patch_status = ticket.status.patches[name]
            prog = self.patch_progress_maker.make_patch_progress(patch_name=name,
                                                                 patch_spec=patch_spec,
                                                                 patch_status=patch_status,
                                                                 release=release,
                                                                 stage=stage,
                                                                 stage_spec_ts=spec_ts)
            status.patches[name].progress.CopyFrom(prog)
            agg.update_by_patch_progress(prog)
            if not changed:
                changed = yputil.patch_progress_changed(patch_status.progress,
                                                        prog)
        status.progress.CopyFrom(agg.make_ticket_progress(ticket.status))
        self.deploy_progress_maker.make_deploy_progress(stage, ticket, status)
        if not changed:
            changed = yputil.deploy_progress_changed(ticket.status.progress, status.progress)

        return status, changed
