#include "main.h"

#include <infra/resource_cache_controller/libs/config/config.pb.h>

#include <infra/resource_cache_controller/libs/manager_factory/resource_cache_gc_manager.h>
#include <infra/resource_cache_controller/libs/manager_factory/resource_cache_manager.h>

#include <infra/libs/controller/daemon/main.h>

namespace NInfra::NResourceCacheController {

int RunDaemon(int argc, const char* argv[]) {
    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");
    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());
 
    TVector<NController::TSingleClusterObjectManagerFactoryPtr> objectFactories({
        new TResourceCacheManagerFactory(shardsFactory.GetShard(0)),
        new TResourceCacheGCManagerFactory(
            config.GetResourceCacheGCManagerFactory()
            , shardsFactory.GetShard(0)
        )
    });

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    return NController::RunDaemon(
        configHolder->Accessor<NController::TControllerConfig>("Controller")
        , std::move(objectFactories)
    );
}

} // namespace NInfra::NResourceCacheController
