#pragma once

#include <infra/resource_cache_controller/libs/config/config.pb.h>

#include <infra/libs/controller/object_manager/object_manager.h>

namespace NInfra::NResourceCacheController {

class TResourceCacheGCManager : public NController::ISingleClusterObjectManager {
public:
    TResourceCacheGCManager(
        const TString& podId
        , const TString podSetId
    )
        : PodId_(podId)
        , PodSetId_(podSetId)
    {}

    virtual TString GetObjectId() const override final;

    virtual TVector<TSelectArgument> GetDependentObjectsSelectArguments() const override final;

    virtual void GenerateYpUpdates(
        const ISingleClusterObjectManager::TDependentObjects& dependentObjects
        , TVector<ISingleClusterObjectManager::TRequest>& requests
        , TLogFramePtr frame
    ) const override final;

private:
    const TString PodId_;
    const TString PodSetId_;
};

class TResourceCacheGCManagerFactory : public NController::ISingleClusterObjectManagerFactory {
public:
    TResourceCacheGCManagerFactory(
        const TResourceCacheGCManagerFactoryConfig& config
        , NController::TShardPtr shard
    );

    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;

    virtual TExpected<NController::TSingleClusterObjectManagerPtr, TValidationError> GetSingleClusterObjectManager(
        const NController::TSelectorResultPtr& selectorResultPtr
        , TLogFramePtr frame
    ) const override final;
};

} // namespace NInfra::NResourceCacheController
