#pragma once

#include <infra/libs/controller/object_manager/object_manager.h>

namespace NInfra::NResourceCacheController {

class TResourceCacheManager : public NController::ISingleClusterObjectManager {
public:
    TResourceCacheManager(
        const NYP::NClient::TResourceCache& resourceCache
    )
        : ResourceCache_(resourceCache)
    {}

    virtual TString GetObjectId() const override final;

    virtual TVector<TSelectArgument> GetDependentObjectsSelectArguments() const override final;

    virtual void GenerateYpUpdates(
        const ISingleClusterObjectManager::TDependentObjects& dependentObjects
        , TVector<ISingleClusterObjectManager::TRequest>& requests
        , TLogFramePtr frame
    ) const override final;

private:
    TVector<NYP::NClient::TPod> FillPods(
        const TVector<NController::TSelectorResultPtr>& selectResults
    ) const;

private:
    NYP::NClient::TResourceCache ResourceCache_;
};

class TResourceCacheManagerFactory : public NController::ISingleClusterObjectManagerFactory {
public:
    TResourceCacheManagerFactory(NController::TShardPtr shard);

    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;

    virtual TExpected<NController::TSingleClusterObjectManagerPtr, TValidationError> GetSingleClusterObjectManager(
        const NController::TSelectorResultPtr& selectorResultPtr
        , TLogFramePtr frame
    ) const override final;
};

} // namespace NInfra::NResourceCacheController
