#include "test_functions.h"

#include <infra/libs/logger/logger.h>

namespace NInfra::NResourceCacheController::NManagerFactoryTestLib {

static TLogger logger({});

NJson::TJsonValue ToJson(const TString& val) {
    TStringStream buf;
    NJson2Yson::ConvertYson2Json(val, &buf);
    return NJson::ReadJsonTree(&buf, true);
}

void GenerateYpUpdates(
    const NController::TSingleClusterObjectManagerPtr manager
    , const NController::ISingleClusterObjectManager::TDependentObjects& dependentObjects
    , TVector<NYP::NClient::TCreateObjectRequest>& create
    , TVector<NYP::NClient::TRemoveObjectRequest>& remove
    , TVector<NYP::NClient::TUpdateRequest>& update
) {
    TVector<NController::ISingleClusterObjectManager::TRequest> requests;
    manager->GenerateYpUpdates(dependentObjects, requests, logger.SpawnFrame());

    for (auto& req : requests) {
        if (std::holds_alternative<NYP::NClient::TCreateObjectRequest>(req)) {
            create.emplace_back(std::move(std::get<NYP::NClient::TCreateObjectRequest>(req)));
        } else if (std::holds_alternative<NYP::NClient::TRemoveObjectRequest>(req)) {
            remove.emplace_back(std::move(std::get<NYP::NClient::TRemoveObjectRequest>(req)));
        } else if (std::holds_alternative<NYP::NClient::TUpdateRequest>(req)) {
            update.emplace_back(std::move(std::get<NYP::NClient::TUpdateRequest>(req)));
        }
    }
}

} // namespace NInfra::NResourceCacheController::NManagerFactoryTestLib
