#pragma once

#include <infra/libs/controller/object_manager/object_manager.h>

namespace NInfra::NResourceCacheController::NManagerFactoryTestLib {

template<class T>
TString ToYson(const T& s) {
    return NYT::NYson::ConvertToYsonString(s).ToString();
}

NJson::TJsonValue ToJson(const TString& val);

void GenerateYpUpdates(
    const NController::TSingleClusterObjectManagerPtr manager
    , const NController::ISingleClusterObjectManager::TDependentObjects& dependentObjects
    , TVector<NYP::NClient::TCreateObjectRequest>& create
    , TVector<NYP::NClient::TRemoveObjectRequest>& remove
    , TVector<NYP::NClient::TUpdateRequest>& update
);

} // namespace NInfra::NResourceCacheController::NManagerFactoryTestLib
