from util.generic.string cimport TStringBuf

import json


cdef extern from "infra/resource_cache_controller/libs/standalone_controller/standalone_controller.h" namespace "NInfra::NResourceCacheController":
    cdef cppclass TStandaloneController:
        TStandaloneController(TStringBuf) except +
        void Sync()


cdef class StandaloneController:
    cdef TStandaloneController* _impl

    def __cinit__(self, config):
        json_string = bytes(json.dumps(config))
        self._impl = new TStandaloneController(json_string)

    def sync(self):
        self._impl.Sync()

    def __dealloc__(self):
        del self._impl
