#pragma once

#include <yp/cpp/yp/data_model.h>
#include <yp/cpp/yp/update_request.h>

#include <util/generic/vector.h>

namespace NInfra::NResourceCacheController {

class TResourceCacheController {
public:
    TResourceCacheController(
        const NYP::NClient::TResourceCache& resourceCache
    )
        : LastLoadedResourceCache_(resourceCache)
        , CurrentResourceCache_(resourceCache)
    {
    }

    void ApplySpecToCurrentStatus();
    void AddPodsStatusToCurrentStatus(const TVector<NYP::NClient::TPod>& pods);

    NInfra::NPodAgent::API::TPodAgentResourceCacheSpec GeneratePodAgentResourceCacheSpec() const;

    TVector<NYP::NClient::TUpdateRequest> GenerateUpdates(const TVector<NYP::NClient::TPod>& pods);

    const NYP::NClient::TResourceCache& LastLoadedResourceCache() const {
        return LastLoadedResourceCache_;
    }

    const NYP::NClient::TResourceCache& CurrentResourceCache() const {
        return CurrentResourceCache_;
    }

private:
    NYP::NClient::TResourceCache LastLoadedResourceCache_;
    NYP::NClient::TResourceCache CurrentResourceCache_;
};

} // namespace NInfra::NResourceCacheController
